{{-- resources/views/dashboard/admin.blade.php --}}
@extends('layouts.app')

@section('title', 'Dashboard Admin')
@section('page-title', 'Dashboard')

@push('styles')
<!-- Chart.js CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.0/chart.min.js"></script>
<!-- Additional animations -->
<style>
  @keyframes slideInUp {
    from { opacity: 0; transform: translateY(24px); }
    to { opacity: 1; transform: translateY(0); }
  }
  .animate-slide-up {
    animation: slideInUp 0.6s ease forwards;
  }
</style>
@endpush

@section('content')
<div class="space-y-6">
  {{-- ===== Stats Cards ===== --}}
  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
    <!-- Total Kandidat -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Total Kandidat</p>
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ number_format($totalCandidates ?? 1234) }}</p>
          <div class="flex items-center mt-2 text-sm">
            <i class="fas fa-arrow-up text-green-500 mr-1"></i>
            <span class="text-green-600 font-medium">{{ $candidateGrowthText ?? '+12% dari bulan lalu' }}</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-blue-500 to-purple-600 p-3 rounded-xl">
          <i class="fas fa-users text-white text-xl"></i>
        </div>
      </div>
    </div>

    <!-- Active Users -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Active Users</p>
          @php
            $hr = $activeUsersHr ?? 8;
            $interviewer = $activeUsersInterviewer ?? 17;
          @endphp
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ $hr + $interviewer }}</p>
          <div class="flex items-center mt-2 text-sm">
            <i class="fas fa-arrow-up text-green-500 mr-1"></i>
            <span class="text-green-600 font-medium">HR: {{ $hr }}, Interviewer: {{ $interviewer }}</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-green-500 to-emerald-600 p-3 rounded-xl">
          <i class="fas fa-user-check text-white text-xl"></i>
        </div>
      </div>
    </div>

    <!-- Open Positions -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Open Positions</p>
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ $openPositions ?? 15 }}</p>
          <div class="flex items-center mt-2 text-sm">
            <i class="fas fa-arrow-up text-green-500 mr-1"></i>
            <span class="text-green-600 font-medium">{{ $newPositionsText ?? '+3 posisi baru' }}</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-amber-500 to-orange-600 p-3 rounded-xl">
          <i class="fas fa-briefcase text-white text-xl"></i>
        </div>
      </div>
    </div>

    <!-- Interview Hari Ini -->
    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-all duration-300 hover:-translate-y-1 stat-card">
      <div class="flex items-center justify-between">
        <div>
          <p class="text-sm font-semibold text-gray-600 uppercase tracking-wide">Interview Hari Ini</p>
          <p class="text-3xl font-bold text-gray-900 mt-2">{{ $todayInterviews ?? 12 }}</p>
          <div class="flex items-center mt-2 text-sm">
            @php $reschedules = $reschedules ?? 2; @endphp
            <i class="fas {{ $reschedules > 0 ? 'fa-arrow-down text-red-500' : 'fa-arrow-up text-green-500' }} mr-1"></i>
            <span class="{{ $reschedules > 0 ? 'text-red-600' : 'text-green-600' }} font-medium">{{ $reschedules }} reschedule</span>
          </div>
        </div>
        <div class="bg-gradient-to-br from-red-500 to-rose-600 p-3 rounded-xl">
          <i class="fas fa-calendar-day text-white text-xl"></i>
        </div>
      </div>
    </div>
  </div>

  {{-- ===== Charts & Recent Activity ===== --}}
  <div class="grid grid-cols-1 xl:grid-cols-3 gap-6">
    <!-- Analytics Chart -->
    <div class="xl:col-span-2 bg-white rounded-xl shadow-lg p-6">
      <div class="flex items-center justify-between mb-6">
        <h3 class="text-xl font-bold text-gray-900">Recruitment Analytics</h3>
        <form class="flex items-center space-x-2">
          <select name="range" 
                  onchange="updateChart(this.value)"
                  class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            <option value="30" {{ (request('range') ?? '30')=='30' ? 'selected' : '' }}>Last 30 days</option>
            <option value="90" {{ (request('range') ?? '30')=='90' ? 'selected' : '' }}>Last 3 months</option>
            <option value="180" {{ (request('range') ?? '30')=='180' ? 'selected' : '' }}>Last 6 months</option>
          </select>
        </form>
      </div>
      
      <!-- Chart Container -->
      <div class="relative h-80">
        <canvas id="recruitmentChart"></canvas>
      </div>
    </div>

    <!-- Recent Activity -->
    <div class="bg-white rounded-xl shadow-lg p-6">
      <div class="flex items-center justify-between mb-6">
        <h3 class="text-xl font-bold text-gray-900">Recent Activity</h3>
        @if(Route::has('candidates.index'))
        <a href="{{ route('candidates.index') }}" 
           class="text-blue-600 hover:text-blue-800 text-sm font-medium transition-colors">
          View All
        </a>
        @else
        <span class="text-gray-400 text-sm">View All</span>
        @endif
      </div>

      <div class="space-y-4">
        <!-- Activity Item 1 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            HR
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">Sarah HR</span> menambahkan kandidat baru
            </p>
            <p class="text-xs text-gray-500 mt-1">2 menit yang lalu</p>
          </div>
        </div>

        <!-- Activity Item 2 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-green-500 to-emerald-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            IN
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">John Interviewer</span> menyelesaikan interview
            </p>
            <p class="text-xs text-gray-500 mt-1">15 menit yang lalu</p>
          </div>
        </div>

        <!-- Activity Item 3 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-amber-500 to-orange-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            AD
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">Admin</span> membuat user baru
            </p>
            <p class="text-xs text-gray-500 mt-1">1 jam yang lalu</p>
          </div>
        </div>

        <!-- Activity Item 4 -->
        <div class="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors">
          <div class="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-red-500 to-rose-600 rounded-full flex items-center justify-center text-white font-bold text-sm">
            HR
          </div>
          <div class="flex-1 min-w-0">
            <p class="text-sm text-gray-900">
              <span class="font-semibold">Lisa HR</span> menjadwalkan interview
            </p>
            <p class="text-xs text-gray-500 mt-1">2 jam yang lalu</p>
          </div>
        </div>

        <!-- Show More Button -->
        <div class="pt-4 border-t border-gray-200">
          <button class="w-full text-center text-sm text-blue-600 hover:text-blue-800 font-medium transition-colors">
            <i class="fas fa-chevron-down mr-1"></i>
            Load More Activities
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- {{-- ===== Quick Actions (Optional) ===== --}}
  <div class="bg-white rounded-xl shadow-lg p-6">
    <h3 class="text-xl font-bold text-gray-900 mb-4">Quick Actions</h3>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
      @if(in_array(Auth::user()->role, ['admin','hr']))
        <a href="{{ route('candidates.create') }}" 
           class="flex items-center justify-center p-4 bg-gradient-to-br from-blue-500 to-purple-600 text-white rounded-lg hover:shadow-lg transition-all duration-300 hover:-translate-y-1">
          <i class="fas fa-plus mr-2"></i>
          Add Candidate
        </a>
        
        <a href="{{ route('positions.create') }}" 
           class="flex items-center justify-center p-4 bg-gradient-to-br from-green-500 to-emerald-600 text-white rounded-lg hover:shadow-lg transition-all duration-300 hover:-translate-y-1">
          <i class="fas fa-briefcase mr-2"></i>
          New Position
        </a>
        
        <a href="{{ route('employees.index') }}" 
           class="flex items-center justify-center p-4 bg-gradient-to-br from-amber-500 to-orange-600 text-white rounded-lg hover:shadow-lg transition-all duration-300 hover:-translate-y-1">
          <i class="fas fa-user-check mr-2"></i>
          View Employees
        </a>
      @endif
      
      <button onclick="generateReport()" 
              class="flex items-center justify-center p-4 bg-gradient-to-br from-red-500 to-rose-600 text-white rounded-lg hover:shadow-lg transition-all duration-300 hover:-translate-y-1">
        <i class="fas fa-download mr-2"></i>
        Export Report
      </button>
    </div>
  </div> -->
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
  // Animate stat cards on load
  document.querySelectorAll('.stat-card').forEach((el, i) => {
    el.style.opacity = '0';
    el.style.transform = 'translateY(24px)';
    
    setTimeout(() => {
      el.style.transition = 'all 0.6s ease';
      el.style.opacity = '1';
      el.style.transform = 'translateY(0)';
    }, i * 100);
  });

  // Initialize Chart
  initRecruitmentChart();
});

function initRecruitmentChart() {
  const ctx = document.getElementById('recruitmentChart').getContext('2d');
  
  // Sample data - replace with actual data from controller
  const chartData = {
    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
    datasets: [
      {
        label: 'Applications',
        data: [65, 78, 90, 81, 95, 102],
        borderColor: 'rgb(59, 130, 246)',
        backgroundColor: 'rgba(59, 130, 246, 0.1)',
        fill: true,
        tension: 0.4
      },
      {
        label: 'Interviews',
        data: [28, 35, 42, 38, 45, 51],
        borderColor: 'rgb(16, 185, 129)',
        backgroundColor: 'rgba(16, 185, 129, 0.1)',
        fill: true,
        tension: 0.4
      },
      {
        label: 'Hired',
        data: [12, 15, 18, 16, 20, 23],
        borderColor: 'rgb(245, 158, 11)',
        backgroundColor: 'rgba(245, 158, 11, 0.1)',
        fill: true,
        tension: 0.4
      }
    ]
  };

  new Chart(ctx, {
    type: 'line',
    data: chartData,
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          position: 'top',
          labels: {
            usePointStyle: true,
            padding: 20
          }
        },
        tooltip: {
          mode: 'index',
          intersect: false,
          backgroundColor: 'rgba(0, 0, 0, 0.8)',
          titleColor: 'white',
          bodyColor: 'white',
          borderColor: 'rgba(255, 255, 255, 0.2)',
          borderWidth: 1
        }
      },
      scales: {
        x: {
          grid: {
            color: 'rgba(0, 0, 0, 0.05)'
          }
        },
        y: {
          beginAtZero: true,
          grid: {
            color: 'rgba(0, 0, 0, 0.05)'
          }
        }
      },
      interaction: {
        mode: 'nearest',
        axis: 'x',
        intersect: false
      }
    }
  });
}

function updateChart(range) {
  // Update chart based on selected range
  // This would typically make an AJAX call to get new data
  console.log('Updating chart for range:', range);
  
  // For demo purposes, just show a loading message
  Swal.fire({
    title: 'Updating Chart...',
    text: 'Loading data for ' + range + ' days',
    timer: 1500,
    showConfirmButton: false,
    didOpen: () => {
      Swal.showLoading();
    }
  });
}

function generateReport() {
  Swal.fire({
    title: 'Generate Report',
    text: 'Choose report type to export',
    icon: 'question',
    showCancelButton: true,
    confirmButtonText: 'PDF Report',
    cancelButtonText: 'Excel Report',
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Generate PDF
      Swal.fire('Generating PDF...', 'Please wait', 'info');
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Generate Excel
      Swal.fire('Generating Excel...', 'Please wait', 'info');
    }
  });
}

// Auto-refresh stats every 5 minutes
setInterval(() => {
  // This would typically make an AJAX call to refresh stats
  console.log('Auto-refreshing dashboard stats...');
}, 5 * 60 * 1000);
</script>
@endpush